package ru.yandex.calendar.logic.ics.imp;

import org.apache.commons.lang.NotImplementedException;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.Validate;

/**
 * @author Stepan Koltsov
 */
public abstract class LayerReference {

    private LayerReference() { }

    private static class LayerId extends LayerReference {
        private final long id;

        private LayerId(long id) {
            Validate.isTrue(id > 0);
            this.id = id;
        }

        @Override
        public String toString() {
            return super.toString() + "(" + id + ")";
        }
    }

    private static class DefaultLayer extends LayerReference { }

    private static class DefaultLayerIfCreate extends LayerReference { }

    private static class LayersByCategory extends LayerReference { }

    private static class CreateNewLayer extends LayerReference { }

    private static class GetCreateLayer extends LayerReference { }


    public boolean isCreate() {
        return this instanceof CreateNewLayer || this instanceof GetCreateLayer;
    }


    public boolean isId() {
        return this instanceof LayerId;
    }

    public long getId() {
        return ((LayerId) this).id;
    }

    public Option<Long> getIdSafe() {
        if (isId()) {
            return Option.of(getId());
        } else {
            return Option.empty();
        }
    }

    public static LayerReference id(long id) {
        return new LayerId(id);
    }


    public boolean isDefaultLayer() {
        return this instanceof DefaultLayer;
    }

    public static LayerReference defaultLayer() {
        return new DefaultLayer();
    }

    public boolean isDefaultLayerIfCreate() {
        return this instanceof DefaultLayerIfCreate;
    }

    public static LayerReference defaultLayerIfCreate() { return new DefaultLayerIfCreate(); }

    public boolean isByCategory() {
        return this instanceof LayersByCategory;
    }

    public static LayerReference byCategory() {
        return new LayersByCategory();
    }


    public boolean isGetCreate() {
        return this instanceof GetCreateLayer;
    }

    public static LayerReference getCreate() {
        return new GetCreateLayer();
    }


    public boolean isCreateNew() {
        return this instanceof CreateNewLayer;
    }

    public static LayerReference createNew() {
        return new CreateNewLayer();
    }


    public static LayerReference parse(String string) {
        if (string.equals("DEFAULT")) {
            return defaultLayer();
        } else if (string.equals("GETCREATE")) {
            return getCreate();
        } else if (string.equals("CREATENEW")) {
            return createNew();
        } else if (string.equals("BYCATEGORY")) {
            return byCategory();
        } else if (string.equals("")) {
            // I'm not sure "" is necessary, but everything is possible in calendar // stepancheg@
            return defaultLayer();
        } else {
            return id(Long.parseLong(string));
        }
    }

    /** @deprecated */
    @Override
    @Deprecated
    public boolean equals(Object obj) {
        throw new NotImplementedException();
    }

    /** @deprecated */
    @Override
    @Deprecated
    public int hashCode() {
        throw new NotImplementedException();
    }

    @Override
    public String toString() {
        return getClass().getName();
    }

} //~
