package ru.yandex.calendar.logic.ics.iv5j.ical;

import org.joda.time.DateTimeZone;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.ews.WindowsTimeZones;
import ru.yandex.calendar.logic.ics.iv5j.ical.component.IcsVTimeZone;
import ru.yandex.calendar.util.dates.AuxDateTime;
import ru.yandex.calendar.util.dates.TimeZones;

/**
 * @author Stepan Koltsov
 * @author shinderuk
 */
public class IcsTimeZones {

    private static Option<DateTimeZone> parseUtc(String id) {
        Option<Duration> offset = TimeZones.parseUtcOffset(id);
        if (offset.isPresent()) {
            return Option.of(DateTimeZone.forOffsetMillis((int) offset.get().getMillis()));
        } else {
            return Option.empty();
        }
    }

    private static Option<DateTimeZone> parseEvolutionId(String id) {
        ListF<String> parts = Cf.x(id.split("/"));
        if (parts.size() > 2) {
            return AuxDateTime.getVerifyDateTimeZoneSafe(parts.rtake(2).mkString("/"));
        }
        return Option.empty();
    }

    public static Option<DateTimeZone> forId(String id) {
        Option<DateTimeZone> r;

        r = WindowsTimeZones.getZoneByWinName(id);
        if (r.isPresent()) {
            return Option.of(r.get());
        }

        r = parseUtc(id);
        if (r.isPresent()) {
            return Option.of(r.get());
        }

        r = parseEvolutionId(id);
        if (r.isPresent()) {
            return Option.of(r.get());
        }

        return AuxDateTime.getVerifyDateTimeZoneSafe(id);
    }

    public static IcsVTimeZone icsVTimeZoneForIdFull(String id) {
        return IcsVTimeZone.fromIcal4j(TimeZoneRegistry2.fullTimeZones.getVTimeZone(id)
                .getOrThrow("Unknown timezone: " + id));
    }

    public static IcsVTimeZone icsVTimeZoneForIdForOutlook(String id) {
        return IcsVTimeZone.fromIcal4j(TimeZoneRegistry2.outlookTimeZones.getVTimeZone(id)
                .getOrThrow("Unknown timezone: " + id));
    }

    public static IcsVTimeZone icsVTimeZoneForUtcOffset(long millis) {
        return IcsVTimeZone.fromIcal4j(VTimeZones.vTimeZoneForUtcOffset(Duration.millis(millis)));
    }

} //~
