package ru.yandex.calendar.logic.ics.iv5j.ical;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function2;
import ru.yandex.calendar.logic.event.MainEventWithRelations;
import ru.yandex.calendar.logic.ics.iv5j.ical.component.IcsVEvent;
import ru.yandex.misc.email.Email;

/**
 * @author Stepan Koltsov
 * @see MainEventWithRelations
 */
public class IcsVEventGroup {

    private final Option<String> uid;
    private final ListF<IcsVEvent> events;

    public IcsVEventGroup(Option<String> uid, ListF<IcsVEvent> events) {
        this.uid = uid;
        this.events = events;
    }

    public static IcsVEventGroup single(IcsVEvent event) {
        return new IcsVEventGroup(event.getUid(), Cf.list(event));
    }

    public ListF<IcsVEvent> getEvents() {
        return events;
    }

    public ListF<IcsVEvent> getMasterEvents() {
        return events.filter(IcsVEvent.isRecurrenceF().notF());
    }

    public ListF<IcsVEvent> getRecurrenceEvents() {
        return events.filter(IcsVEvent.isRecurrenceF());
    }

    public Option<String> getUid() {
        return uid;
    }

    public IcsVEvent getMasterOrFirstEvent() {
        return getMasterEvents().firstO().getOrElse(getEvents().first());
    }

    public ListF<Email> getParticipantEmailsSafe() {
        return events.flatMap(IcsVEvent.getParticipantEmailsSafeF()).stableUnique();
    }

    public static Function2<Option<String>, ListF<IcsVEvent>, IcsVEventGroup> consF() {
        return new Function2<Option<String>, ListF<IcsVEvent>, IcsVEventGroup>() {
            public IcsVEventGroup apply(Option<String> uid, ListF<IcsVEvent> vevents) {
                return new IcsVEventGroup(uid, vevents);
            }
        };
    }

    public static Function<IcsVEvent, IcsVEventGroup> cons1F() {
        return new Function<IcsVEvent, IcsVEventGroup>() {
            public IcsVEventGroup apply(IcsVEvent vevent) {
                return new IcsVEventGroup(vevent.getUid(), Cf.list(vevent));
            }
        };
    }

    @Override
    public String toString() {
        return "IcsVEventGroup[" + uid.getOrElse("?") + "," + events.size() + "events]";
    }

} //~
