package ru.yandex.calendar.logic.ics.iv5j.ical;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.logic.ics.iv5j.ical.component.IcsComponent;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsProperty;

/**
 * @author Stepan Koltsov
 */
public abstract class PropertiesComponentsContainer {

    protected final ListF<IcsProperty> properties;
    protected final ListF<IcsComponent> components;

    @SuppressWarnings("unchecked")
    protected PropertiesComponentsContainer(ListF<? extends IcsProperty> properties, ListF<? extends IcsComponent> components) {
        this.properties = (ListF<IcsProperty>) properties;
        this.components = (ListF<IcsComponent>) components;
    }

    protected PropertiesComponentsContainer() {
        this(Cf.list(), Cf.list());
    }

    public ListF<IcsComponent> getComponents() {
        return components;
    }

    public <C extends IcsComponent> ListF<C> getComponents(String name) {
        return components.filter(IcsComponent.nameIs(name)).uncheckedCast();
    }

    public <C extends IcsComponent> ListF<C> getComponents(Class<C> type) {
        return components.filterByType(type);
    }


    public ListF<IcsProperty> getProperties() {
        return properties;
    }

    public <P extends IcsProperty> ListF<P> getProperties(String name) {
        return properties.filter(IcsProperty.nameIsF(name)).uncheckedCast();
    }

    public <P extends IcsProperty> Option<P> getProperty(String name) {
        return this.<P>getProperties(name).singleO();
    }

    public Option<String> getPropertyValue(String name) {
        return getProperty(name).map(IcsProperty::getValue);
    }

    public boolean hasProperty(String name) {
        return getProperty(name).isPresent();
    }

    public static Function1B<PropertiesComponentsContainer> hasPropertyF(final String name) {
        return a -> a.hasProperty(name);
    }

    public static Function<PropertiesComponentsContainer, String> getPropertyValueF(final String name) {
        return a -> a.getPropertyValue(name).get();
    }

    public static Function<PropertiesComponentsContainer, Option<String>> getPropertyValueOF(final String name) {
        return a -> a.getPropertyValue(name);
    }


} //~
