package ru.yandex.calendar.logic.ics.iv5j.ical;

import java.text.DecimalFormat;

import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.UtcOffset;
import net.fortuna.ical4j.model.component.Standard;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.TzId;
import net.fortuna.ical4j.model.property.TzOffsetFrom;
import net.fortuna.ical4j.model.property.TzOffsetTo;
import net.fortuna.ical4j.validate.ValidationException;
import org.joda.time.Duration;

/**
 * @author gutman
 */
public class VTimeZones {

    static VTimeZone vTimeZoneForUtcOffset(Duration duration) {
        PropertyList properties = new PropertyList();
        properties.add(new TzId(utcTzId(duration)));

        ComponentList observances = new ComponentList();
        Standard standard = new Standard();
        UtcOffset utcOffset = new UtcOffset(duration.getMillis());
        standard.getProperties().add(new TzOffsetFrom(utcOffset.toString()));
        standard.getProperties().add(new TzOffsetTo(utcOffset.toString()));
        standard.getProperties().add(new DtStart(new DateTime(0)));
        observances.add(standard);

        VTimeZone vTimeZone = new VTimeZone(properties, observances);
        try {
            vTimeZone.validate(true);
        } catch (ValidationException e) {
            throw new RuntimeException(e);
        }

        return vTimeZone;
    }

    public static final DecimalFormat HOURS_FORMAT = new DecimalFormat("00");
    public static final DecimalFormat MINUTES_FORMAT = new DecimalFormat("00");

    public static String utcTzId(Duration duration) {
        long minutes = duration.getStandardMinutes();
        long absMinutes = Math.abs(minutes);

        if (absMinutes % 60 == 0) {
            String sign = minutes >= 0 ? "-" : "+";
            return "Etc/GMT" + sign + absMinutes / 60;
        }

        String sign = minutes >= 0 ? "+" : "-";
        String hoursString = HOURS_FORMAT.format(absMinutes / 60);
        String minutesString = MINUTES_FORMAT.format(absMinutes % 60);

        return "UTC" + sign + hoursString + ":" + minutesString;
    }

}
