package ru.yandex.calendar.logic.ics.iv5j.ical.component;

import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.component.CalendarComponent;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function0;
import ru.yandex.bolts.function.Function2;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.IcsMeta;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsProperty;
import ru.yandex.calendar.util.base.Cf2;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Stepan Koltsov
 */
public class ComponentMeta extends IcsMeta<IcsComponent, CalendarComponent, ComponentMeta> {

    private final Function0<CalendarComponent> theirConstructor;
    private final Function2<ListF<IcsProperty>, ListF<IcsComponent>, IcsComponent> ourConstructor;

    public ComponentMeta(String name, ClassX<IcsComponent> ourComponent, ClassX<CalendarComponent> theirComponent) {
        super(name, ourComponent, theirComponent);

        theirConstructor = Cf2.consF(theirComponent);
        ourConstructor = Cf2.consF(ourComponent, Cf2.listClass(), Cf2.listClass());
    }

    public Component newComponent() {
        return theirConstructor.apply();
    }

    public IcsComponent newOur(ListF<IcsProperty> properties, ListF<IcsComponent> components) {
        return ourConstructor.apply(properties, components);
    }

    public IcsComponent parseString(String string) {
        String ics = "BEGIN:VCALENDAR\n" + string.trim() + "\nEND:VCALENDAR\n";
        return IcsCalendar.parseString(ics).getComponents().single();
    }

} //~
