package ru.yandex.calendar.logic.ics.iv5j.ical.component;

import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.component.XComponent;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.IcssMeta;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsProperty;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.PropertiesMeta;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Stepan Koltsov
 */
public class ComponentsMeta
    extends IcssMeta<IcsComponent, IcsXComponent, CalendarComponent, XComponent, ComponentMeta>
{
    public static final ComponentsMeta M = new ComponentsMeta();

    private ComponentsMeta() {
        super(new Class[] {
                IcsDaylight.class,
                IcsStandard.class,
                IcsVAlarm.class,
                IcsVAvailability.class,
                IcsVEvent.class,
                IcsVFreeBusy.class,
                IcsVJournal.class,
                IcsVTimeZone.class,
                IcsVToDo.class,
                IcsVVenue.class,
        });
    }

    @Override
    protected ComponentMeta newMeta(String name, ClassX<IcsComponent> ourClass, ClassX<CalendarComponent> theirClass) {
        return new ComponentMeta(name, ourClass, theirClass);
    }

    public Component newTheir(String name) {
        Option<ComponentMeta> m = metaByName(name);
        if (m.isPresent()) {
            return m.get().newComponent();
        } else {
            return new XComponent(name);
        }
    }

    public IcsComponent newOur(String name, ListF<IcsProperty> properties, ListF<IcsComponent> components) {
        Option<ComponentMeta> m = metaByName(name);
        if (m.isPresent()) {
            return m.get().newOur(properties, components);
        } else {
            return new IcsXComponent(name, properties, components);
        }
    }

    public IcsVEvent fromIcal4j(VEvent ve) {
        return (IcsVEvent) fromIcal4j((Component) ve);
    }

    public IcsVToDo fromIcal4j(VToDo vtodo) {
        return (IcsVToDo) fromIcal4j((Component) vtodo);
    }

    @SuppressWarnings("unchecked")
    private ListF<Component> getComponents(Component component) {
        if (component instanceof VEvent) {
            return Cf.x(((VEvent) component).getAlarms()).uncheckedCast();
        } else if (component instanceof VToDo) {
            return Cf.x(((VToDo) component).getAlarms()).uncheckedCast();
        } else if (component instanceof VTimeZone) {
            return Cf.x(((VTimeZone) component).getObservances()).uncheckedCast();
        } else {
            // XXX: add others
            return Cf.list();
        }
    }

    @SuppressWarnings("unchecked")
    public IcsComponent fromIcal4j(Component component) {
        ListF<Property> theirProperties = Cf.<Property>x(component.getProperties());
        ListF<Component> theirComponents = getComponents(component);

        ListF<IcsProperty> ourProperties = theirProperties.map(PropertiesMeta.M.fromIcal4jF());
        ListF<IcsComponent> ourComponents = theirComponents.map(ComponentsMeta.M.fromIcal4jF());

        return newOur(component.getName(), ourProperties, ourComponents);
    }

    public Function<Component, IcsComponent> fromIcal4jF() {
        return new Function<Component, IcsComponent>() {
            public IcsComponent apply(Component c) {
                return fromIcal4j(c);
            }
        };
    }


} //~
