package ru.yandex.calendar.logic.ics.iv5j.ical.component;

import java.util.List;

import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.component.Observance;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsVTimeZones;
import ru.yandex.calendar.logic.ics.iv5j.ical.PropertiesComponentsContainer;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.ParametersMeta;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsAttendee;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsDtEnd;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsDtStamp;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsDtStart;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsDuration;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsExDate;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsLastModified;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsOrganizer;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsProperty;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsRDate;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsRRule;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.PropertiesMeta;

/**
 * @author Stepan Koltsov
 */
public abstract class IcsComponent extends PropertiesComponentsContainer {
    private final String name;

    protected IcsComponent(String name, ListF<? extends IcsProperty> properties, ListF<? extends IcsComponent> components) {
        super(properties, components);
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public ListF<IcsRRule> getRRules() {
        return getProperties(RRule.RRULE);
    }

    public ListF<IcsExDate> getExDates() {
        return getProperties(ExDate.EXDATE);
    }

    public ListF<IcsRDate> getRDates() {
        return getProperties(RDate.RDATE);
    }

    public ListF<IcsAttendee> getAttendees() {
        return getProperties(Attendee.ATTENDEE);
    }

    public Option<IcsOrganizer> getOrganizer() {
        return getProperty(Organizer.ORGANIZER);
    }

    public Option<IcsDtStart> getDtStart() {
        return this.getProperty(DtStart.DTSTART);
    }

    public Option<IcsDtEnd> getDtEnd() {
        return this.getProperty(DtEnd.DTEND);
    }

    public Option<IcsDuration> getDuration() {
        return this.getProperty(Duration.DURATION);
    }

    public Option<IcsLastModified> getLastModified() {
        return this.getProperty(LastModified.LAST_MODIFIED);
    }

    public Option<Instant> getLastModifiedInstant(IcsVTimeZones tz) {
        return getLastModified().map(IcsLastModified.getInstantF(tz));
    }

    public Option<IcsDtStamp> getDtStamp() {
        return getProperty(DtStamp.DTSTAMP);
    }

    /**
     * tz is passed here to workaround invite incorrect ics
     * see IcsImporterNonMeetingCreateTest#bugDen()
     */
    public Option<Instant> getDtStampInstant(IcsVTimeZones tz) {
        return getDtStamp().map(IcsDtStamp.getInstantF(tz));
    }

    public IcsComponent withProperties(ListF<IcsProperty> properties) {
        return ComponentsMeta.M.newOur(name, properties, getComponents());
    }

    public IcsComponent removeProperties(String name) {
        return filterProperties(IcsProperty.nameF().andThenEquals(name).notF());
    }

    public IcsComponent filterProperties(Function1B<? super IcsProperty> f) {
        return withProperties(properties.filter(f));
    }

    public IcsComponent addProperty(IcsProperty property) {
        return withProperties(properties.plus1(property));
    }

    public IcsComponent addProperties(List<? extends IcsProperty> additionalProperties) {
        return withProperties(properties.plus(additionalProperties));
    }

    public IcsComponent addComponent(IcsComponent component) {
        return ComponentsMeta.M.newOur(name, properties, getComponents().plus1(component));
    }

    public Component toComponent() {
        Component r = ComponentsMeta.M.newTheir(name);
        r.getProperties().clear();
        for (IcsProperty p : properties) {
            r.getProperties().add(p.toProperty());
        }
        for (IcsComponent component : getComponents()) {
            if (r instanceof VEvent) {
                ((VEvent) r).getAlarms().add((VAlarm) component.toComponent());
            } else if (r instanceof VTimeZone) {
                ((VTimeZone) r).getObservances().add((Observance) component.toComponent());
            } else {
                // ?
            }
        }
        return r;
    }

    public Component toComponentForSerialization() {
        Component r = ComponentsMeta.M.newTheir(name);
        r.getProperties().clear();
        for (IcsProperty p : properties) {
            r.getProperties().add(p.toPropertyForSerialization());
        }
        for (IcsComponent component : getComponents()) {
            if (r instanceof VEvent) {
                ((VEvent) r).getAlarms().add((VAlarm) component.toComponentForSerialization());
            } else if (r instanceof VToDo) {
                ((VToDo) r).getAlarms().add((VAlarm) component.toComponentForSerialization());
            } else if (r instanceof VTimeZone) {
                ((VTimeZone) r).getObservances().add((Observance) component.toComponentForSerialization());
            } else {
                // ?
            }
        }
        return r;
    }

    @Override
    public String toString() {
        // XXX: will be changed
        return serializeToString();
    }

    public String serializeToString() {
        return toComponent().toString();
    }

    public static Function<IcsComponent, String> nameF() {
        return new Function<IcsComponent, String>() {
            public String apply(IcsComponent p) {
                return p.name;
            }
        };
    }

    public static Function1B<IcsComponent> nameIs(String name) {
        return nameF().andThenEquals(name);
    }

    public IcsComponent withTzIdParametersValue(String tzId) {
        Function<IcsProperty, IcsProperty> withTzIdF = property -> {
            if (property.hasParameter(Parameter.TZID)) {
                ListF<IcsParameter> parameters = property.getParameters().map(parameter -> {
                    if (Parameter.TZID.equals(parameter.getName())) {
                        return ParametersMeta.M.newOurParameter(parameter.getName(), tzId);
                    }
                    return parameter;
                });
                return PropertiesMeta.M.newOur(property.getName(), property.getValue(), parameters);
            }
            return property;
        };
        ListF<IcsProperty> properties = getProperties().map(withTzIdF);
        ListF<IcsComponent> components = getComponents().map(c -> c.withTzIdParametersValue(tzId));

        return ComponentsMeta.M.newOur(getName(), properties, components);
    }
} //~
