package ru.yandex.calendar.logic.ics.iv5j.ical.component;

import net.fortuna.ical4j.model.Component;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsProperty;

/**
 * @author Stepan Koltsov
 */
public abstract class IcsComponentBase<S extends IcsComponent, T extends Component> extends IcsComponent {

    protected IcsComponentBase(String name, ListF<? extends IcsProperty> properties, ListF<? extends IcsComponent> components) {
        super(name, properties, components);
    }

    @SuppressWarnings("unchecked")
    @Override
    public S filterProperties(Function1B<? super IcsProperty> f) {
        return (S) super.filterProperties(f);
    }

    @SuppressWarnings("unchecked")
    @Override
    public S addProperty(IcsProperty property) {
        return (S) super.addProperty(property);
    }

    @SuppressWarnings("unchecked")
    @Override
    public S removeProperties(String name) {
        return (S) super.removeProperties(name);
    }

    @SuppressWarnings("unchecked")
    @Override
    public S addComponent(IcsComponent component) {
        return (S) super.addComponent(component);
    }

    @SuppressWarnings("unchecked")
    @Override
    public T toComponent() {
        return (T) super.toComponent();
    }

    @SuppressWarnings("unchecked")
    @Override
    public T toComponentForSerialization() {
        return (T) super.toComponentForSerialization();
    }

    @SuppressWarnings("unchecked")
    @Override
    public S withTzIdParametersValue(String tzId) {
        return (S) super.withTzIdParametersValue(tzId);
    }
} //~
