package ru.yandex.calendar.logic.ics.iv5j.ical.component;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VTimeZone;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsProperty;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=CalendarComponent.VTIMEZONE, theirClass=VTimeZone.class)
public class IcsVTimeZone extends IcsComponentBase<IcsVTimeZone, VTimeZone> {

    public IcsVTimeZone(ListF<? extends IcsProperty> properties, ListF<? extends IcsComponent> components) {
        super(CalendarComponent.VTIMEZONE, properties, components);
    }

    public ListF<IcsStandard> getStandards() {
        return getComponents(IcsStandard.class);
    }

    public ListF<IcsDaylight> getDaylights() {
        return getComponents(IcsDaylight.class);
    }

    public ListF<IcsObservance<?, ?>> getObservances() {
        return getComponents().filterByType(IcsObservance.class).uncheckedCast();
    }

    public String getTzId() {
        return getPropertyValue(Property.TZID).get();
    }

    public static IcsVTimeZone fromIcal4j(VTimeZone ve) {
        return (IcsVTimeZone) ComponentsMeta.M.fromIcal4j(ve);
    }

} //~
