package ru.yandex.calendar.logic.ics.iv5j.ical.component;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VToDo;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsVTimeZones;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsCompleted;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsDescription;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsDtStamp;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsDtStart;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsDue;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsProperty;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsStatus;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsSummary;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsUid;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.PropertiesMeta;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTime;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=CalendarComponent.VTODO, theirClass=VToDo.class)
public class IcsVToDo extends IcsComponentBase<IcsVToDo, VToDo> {

    public IcsVToDo(ListF<IcsProperty> properties, ListF<? extends IcsComponent> components) {
        super(CalendarComponent.VTODO, properties, components);
    }

    public IcsVToDo() {
        this(Cf.<IcsProperty>list(), Cf.<IcsVAlarm>list());
    }

    public ListF<IcsVAlarm> getVAlarms() {
        return getComponents().uncheckedCast();
    }

    public Option<IcsDue> getDue() {
        return getProperty(Property.DUE);
    }

    public Option<Instant> getDueInstant(IcsVTimeZones tz) {
        return getDue().map(IcsDue.getInstantF(tz));
    }

    public Option<String> getUid() {
        return getPropertyValue(Property.UID);
    }

    public Option<String> getSummary() {
        return getPropertyValue(Property.SUMMARY);
    }

    public Option<String> getDescription() {
        return getPropertyValue(Property.DESCRIPTION);
    }

    public Option<IcsCompleted> getCompleted() {
        return getProperty(Property.COMPLETED);
    }

    public Option<Instant> getCompletedInstant(IcsVTimeZones tz) {
        return getCompleted().map(IcsCompleted.getInstantF(tz));
    }

    public IcsVToDo withVAlarm(IcsVAlarm vAlarm) {
        return new IcsVToDo(getProperties(), getComponents().plus1(vAlarm));
    }

    public IcsVToDo withSummary(String summary) {
        return this
            .removeProperties(Property.SUMMARY)
            .addProperty(new IcsSummary(summary));
    }

    public IcsVToDo withDescription(String description) {
        return this
            .removeProperties(Property.DESCRIPTION)
            .addProperty(new IcsDescription(description));
    }

    public IcsVToDo withUid(String uid) {
        return this
            .removeProperties(Property.UID)
            .addProperty(new IcsUid(uid));
    }

    public IcsVToDo withDtStart(IcsDateTime time) {
        return this
            .removeProperties(Property.DTSTART)
            .addProperty(new IcsDtStart(time));
    }

    public IcsVToDo withDue(IcsDue due) {
        return this
            .removeProperties(Property.DUE)
            .addProperty(due);
    }

    public IcsVToDo withDue(IcsDateTime time) {
        return withDue(new IcsDue(time));
    }

    public IcsVToDo withDue(DateTime time) {
        return withDue(IcsDateTime.dateTime(time));
    }

    public IcsVToDo withDue(Instant time) {
        return withDue(IcsDateTime.instant(time));
    }

    public IcsVToDo withDue(LocalDate due) {
        return withDue(IcsDateTime.localDate(due));
    }

    public IcsVToDo withCompleted(IcsCompleted completed) {
        return this
            .removeProperties(Property.COMPLETED)
            .addProperty(completed);
    }

    public IcsVToDo withCompleted(IcsDateTime time) {
        return withCompleted(new IcsCompleted(time));
    }

    public IcsVToDo withCompleted(Instant completed) {
        return withCompleted(IcsDateTime.instant(completed));
    }

    public IcsVToDo withStatus(String value) {
        return addProperty(new IcsStatus(value, Cf.<IcsParameter>list()));
    }

    public IcsCalendar makeCalendar() {
        return new IcsCalendar(Cf.list(this));
    }

    public IcsVToDo withDtStampNow() {
        return withDtStamp(new Instant());
    }

    public IcsVToDo withDtStamp(Instant dtStamp) {
        return withDtStamp(new IcsDtStamp(dtStamp));
    }

    public IcsVToDo withDtStamp(IcsDtStamp dtStamp) {
        return this
            .removeProperties(Property.DTSTAMP)
            .addProperty(dtStamp);
    }

    public IcsVToDo withProperty(String name, String value) {
        return this.removeProperties(name).addProperty(PropertiesMeta.M.newOur(name, value));
    }

    public IcsVToDo withPropertyIfNotEmpty(String name, String value) {
        return StringUtils.isNotEmpty(value) ? this.withProperty(name, value) : this;
    }

    public IcsVToDo withPropertyIfDefined(String name, Option<? extends Number> value) {
        return value.isPresent() ? this.withProperty(name, value.get().toString()) : this;
    }

    public static IcsVToDo fromIcal4j(VToDo vtodo) {
        return ComponentsMeta.M.fromIcal4j(vtodo);
    }

} //~
