package ru.yandex.calendar.logic.ics.iv5j.ical.meta;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Stepan Koltsov
 */
public abstract class IcssMeta<O, OX extends O, T, TX extends T, M extends IcsMeta<O, T, M>> {

    private final MapF<String, M> byName;
    private final MapF<ClassX<T>, M> byTheirClass;

    @SuppressWarnings({ "unchecked", "rawtypes" })
    protected IcssMeta(Class[] ourClasses) {
        ListF<ClassX<O>> ourClasses1 = Cf.<Class<O>>x(ourClasses).map(ClassX.wrapF());

        ListF<M> components = ourClasses1.map(this::byClass);

        this.byName = components.toMapMappingToKey(IcsMeta::getName);
        this.byTheirClass = components.toMapMappingToKey(IcsMeta::getTheirClass);
    }

    protected abstract M newMeta(String name, ClassX<O> ourClass, ClassX<T> theirClass);

    @SuppressWarnings({ "unchecked" })
    private M byClass(ClassX<O> clazz) {
        MappingToIcal4j mapping = clazz.getAnnotation(MappingToIcal4j.class);
        Check.C.notNull(mapping, "class " + clazz + " has no MappingToIcal4j annotation");
        return newMeta(mapping.name(), clazz, ClassX.wrap((Class<T>) mapping.theirClass()));
    }

    public Option<M> metaByName(String name) {
        Validate.isTrue(name.toUpperCase().equals(name));
        return byName.getO(name);
    }

    protected Option<M> metaByTheirClass(ClassX<T> clazz) {
        return byTheirClass.getO(clazz);
    }

} //~
