package ru.yandex.calendar.logic.ics.iv5j.ical.parameter;

import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.parameter.CuType;

import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=Parameter.CUTYPE, theirClass=CuType.class)
public class IcsCuType extends IcsParameter {

    public static final IcsCuType INDIVIDUAL = new IcsCuType("INDIVIDUAL");

    public static final IcsCuType GROUP = new IcsCuType("GROUP");

    public static final IcsCuType RESOURCE = new IcsCuType("RESOURCE");

    public static final IcsCuType ROOM = new IcsCuType("ROOM");

    public static final IcsCuType UNKNOWN = new IcsCuType("UNKNOWN");

    public IcsCuType(String value) {
        super(Parameter.CUTYPE, value);
    }

    public static IcsCuType valueOf(String type) {
        if (type.equals("INDIVIDUAL")) {
            return INDIVIDUAL;
        } else if (type.equals("GROUP")) {
            return GROUP;
        } else if (type.equals("RESOURCE")) {
            return RESOURCE;
        } else if (type.equals("ROOM")) {
            return ROOM;
        } else if (type.equals("UNKNOWN")) {
            return UNKNOWN;
        } else {
            return new IcsCuType(type);
        }
    }

} //~
