package ru.yandex.calendar.logic.ics.iv5j.ical.parameter;

import net.fortuna.ical4j.model.Parameter;

import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.misc.lang.Validate;

/**
 * @author Stepan Koltsov
 */
public abstract class IcsParameter {
    private final String name;
    private final String value;

    protected IcsParameter(String name, String value) {
        Validate.notEmpty(name);
        Validate.notNull(value);
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public String getValue() {
        return value;
    }

    public Parameter toParameter() {
        return ParametersMeta.M.newTheirParameter(name, value);
    }

    public final boolean isSame(IcsParameter that) {
        return this.name.equals(that.name) && this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return Tuple2.tuple(name, value).hashCode();
    }

    @Override
    public final boolean equals(Object that) {
        return that instanceof IcsParameter && isSame((IcsParameter) that);
    }

    public final boolean sameAs(IcsParameter that) {
        return this.name.equals(that.name) && this.value.equals(that.value);
    }

    public static Function<IcsParameter, String> nameF() {
        return new Function<IcsParameter, String>() {
            public String apply(IcsParameter p) {
                return p.name;
            }
        };
    }

    public static Function1B<IcsParameter> nameIsF(String name) {
        return nameF().andThenEquals(name);
    }

    public String serialize() {
        return toParameter().toString();
    }

    public String toString() {
        return serialize();
    }

    public static Function<IcsParameter, String> getValueF() {
        return new Function<IcsParameter, String>() {
            public String apply(IcsParameter p) {
                return p.getValue();
            }
        };
    }

} //~
