package ru.yandex.calendar.logic.ics.iv5j.ical.parameter;

import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.parameter.Value;

import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;

@MappingToIcal4j(name=Parameter.VALUE, theirClass=Value.class)
public class IcsValue extends IcsParameter {

    public static final IcsValue BINARY = new IcsValue("BINARY");

    public static final IcsValue BOOLEAN = new IcsValue("BOOLEAN");

    public static final IcsValue CAL_ADDRESS = new IcsValue("CAL-ADDRESS");

    public static final IcsValue DATE = new IcsValue("DATE");

    public static final IcsValue DATE_TIME = new IcsValue("DATE-TIME");

    public static final IcsValue DURATION = new IcsValue("DURATION");

    public static final IcsValue FLOAT = new IcsValue("FLOAT");

    public static final IcsValue INTEGER = new IcsValue("INTEGER");

    public static final IcsValue PERIOD = new IcsValue("PERIOD");

    public static final IcsValue RECUR = new IcsValue("RECUR");

    public static final IcsValue TEXT = new IcsValue("TEXT");

    public static final IcsValue TIME = new IcsValue("TIME");

    public static final IcsValue URI = new IcsValue("URI");

    public static final IcsValue UTC_OFFSET = new IcsValue("UTC-OFFSET");


    public IcsValue(String value) {
        super(Parameter.VALUE, value);
    }

} //~
