package ru.yandex.calendar.logic.ics.iv5j.ical.parameter;

import net.fortuna.ical4j.model.Parameter;

import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.IcsMeta;
import ru.yandex.calendar.util.base.Cf2;
import ru.yandex.misc.reflection.ClassX;

public class ParameterMeta extends IcsMeta<IcsParameter, Parameter, ParameterMeta> {

    private final Function<String, Parameter> theirConstructor;
    private final Function<String, IcsParameter> ourConstructor;

    public ParameterMeta(String name, ClassX<IcsParameter> ourComponent, ClassX<Parameter> theirComponent) {
        super(name, ourComponent, theirComponent);

        ourConstructor = Cf2.consF(ourComponent, String.class);
        theirConstructor = Cf2.consF(theirComponent, String.class);
    }

    public Parameter newTheir(String value) {
        return theirConstructor.apply(value);
    }

    public IcsParameter newOur(String value) {
        return ourConstructor.apply(value);
    }

} //~
