package ru.yandex.calendar.logic.ics.iv5j.ical.parameter;

import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.parameter.XParameter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.IcssMeta;
import ru.yandex.misc.reflection.ClassX;

public class ParametersMeta extends IcssMeta<IcsParameter, IcsXParameter, Parameter, XParameter, ParameterMeta> {

    public static final ParametersMeta M = new ParametersMeta();

    private ParametersMeta() {
        super(new Class[] {
                IcsAbbrev.class,
                IcsAltRep.class,
                IcsCn.class,
                IcsCuType.class,
                IcsDelegatedFrom.class,
                IcsDelegatedTo.class,
                IcsDir.class,
                IcsEncoding.class,
                IcsFbType.class,
                IcsFmtType.class,
                IcsLanguage.class,
                IcsMember.class,
                IcsPartStat.class,
                IcsRange.class,
                IcsRelType.class,
                IcsRelated.class,
                IcsRole.class,
                IcsRsvp.class,
                IcsScheduleAgent.class,
                IcsScheduleStatus.class,
                IcsSentBy.class,
                IcsType.class,
                IcsTzId.class,
                IcsValue.class,
                IcsVvenue.class,
                IcsDisplay.class,
                IcsEmail.class,
                IcsFeature.class,
                IcsLabel.class,
        });
    }

    @Override
    protected ParameterMeta newMeta(String name, ClassX<IcsParameter> ourClass, ClassX<Parameter> theirClass) {
        return new ParameterMeta(name, ourClass, theirClass);
    }

    public Parameter newTheirParameter(String name, String value) {
        Option<ParameterMeta> m = metaByName(name);
        if (m.isPresent()) {
            return m.get().newTheir(value);
        } else {
            return new XParameter(name, value);
        }
    }

    public IcsParameter newOurParameter(String name, String value) {
        Option<ParameterMeta> m = metaByName(name);
        if (m.isPresent()) {
            return m.get().newOur(value);
        } else {
            return new IcsXParameter(name, value);
        }
    }

    public IcsParameter fromIcal4j(Parameter parameter) {
        return newOurParameter(parameter.getName(), parameter.getValue());
    }

    public Function<Parameter, IcsParameter> fromIcal4jF() {
        return new Function<Parameter, IcsParameter>() {
            public IcsParameter apply(Parameter p) {
                return fromIcal4j(p);
            }
        };
    }

}
