package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.Action;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=Property.ACTION, theirClass=Action.class)
public class IcsAction extends IcsPropertyBase<IcsAction, Action> {

    public static final IcsAction AUDIO = new IcsAction("AUDIO");

    public static final IcsAction DISPLAY = new IcsAction("DISPLAY");

    public static final IcsAction EMAIL = new IcsAction("EMAIL");

    public static final IcsAction PROCEDURE = new IcsAction("PROCEDURE");


    public IcsAction(String value, ListF<IcsParameter> parameters) {
        super(Property.ACTION, value, parameters);
    }

    public IcsAction(String value) {
        this(value,  Cf.<IcsParameter>list());
    }
} //~
