package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.property.Attendee;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsPartStat;
import ru.yandex.calendar.util.email.Emails;
import ru.yandex.misc.email.Email;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=Property.ATTENDEE, theirClass=Attendee.class)
public class IcsAttendee extends IcsEmailPropertyBase<IcsAttendee, Attendee> {

    public IcsAttendee(String value, ListF<? extends IcsParameter> parameters) {
        super(Property.ATTENDEE, value, parameters);
    }

    public IcsAttendee(Email email) {
        this(Emails.getUnicodedMailto(email), Cf.<IcsParameter>list());
    }

    public IcsAttendee(Email email, IcsPartStat partStat) {
        this(Emails.getUnicodedMailto(email), Cf.list(partStat));
    }

    public Option<IcsPartStat> getPartStat() {
        return getParameter(PartStat.PARTSTAT);
    }

    public static IcsAttendee fromIcal4j(Attendee attendee) {
        return (IcsAttendee) PropertiesMeta.M.fromIcal4j(attendee);
    }

} //~
