package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.Completed;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTime;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=Property.COMPLETED, theirClass=Completed.class)
public class IcsCompleted extends IcsDateTimePropertyBase<IcsCompleted, Completed> {

    public IcsCompleted(String value, ListF<IcsParameter> parameters) {
        super(Property.COMPLETED, value, parameters);
    }

    public IcsCompleted(IcsDateTime time) {
        super(Property.COMPLETED, time);
    }

    public IcsCompleted(Instant instant) {
        this(IcsDateTime.instant(instant));
    }

} //~
