package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.Created;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTime;

/**
 * @author Stepan Koltsov
 * @url http://tools.ietf.org/html/rfc5545#section-3.8.7.1
 */
@MappingToIcal4j(name=Property.CREATED, theirClass=Created.class)
public class IcsCreated extends IcsDateTimePropertyBase<IcsCreated, Created> {

    public IcsCreated(String value, ListF<IcsParameter> parameters) {
        super(Property.CREATED, value, parameters);
    }

    public IcsCreated(IcsDateTime time) {
        super(Property.CREATED, time);
    }

    public IcsCreated(Instant instant) {
        this(IcsDateTime.instant(instant));
    }

} //~
