package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DateListProperty;
import net.fortuna.ical4j.model.property.XProperty;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsValue;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTime;

/**
 * @author Stepan Koltsov
 */
public abstract class IcsDateTimeListPropertyBase<A extends IcsDateTimeListPropertyBase<A, B>, B extends DateListProperty>
        extends IcsTimeZoneAwarePropertyBase<A, B>
{

    protected IcsDateTimeListPropertyBase(String name, String value, ListF<? extends IcsParameter> parameters) {
        super(name, value, parameters);
    }

    protected IcsDateTimeListPropertyBase(String name, IcsDateTime dateTime) {
        this(name, dateTime.toPropertyValue(), dateTime.toPropertyParameters());
    }

    protected IcsDateTimeListPropertyBase(String name, Instant instant) {
        this(name, IcsDateTime.instant(instant));
    }

    public Option<IcsValue> getValueParameter() {
        return getParameter(Value.VALUE);
    }

    protected ListF<String> getValues() {
        return Cf.list(getValue().split(","));
    }

    @Override
    public Property toPropertyForSerialization() {
        // workaround against net.fortuna.ical4j.model.property.DateProperty (it parses date and always prints date with time part)
        XProperty xProperty = new XProperty(getName(), getValue());
        for (IcsParameter parameter : getParameters()) {
            xProperty.getParameters().add(parameter.toParameter());
        }
        return xProperty;
    }

} //~
