package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.property.XProperty;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsVTimeZones;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTime;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTimeFormats;

/**
 * @author Stepan Koltsov
 */
public abstract class IcsDateTimePropertyBase<A extends IcsDateTimePropertyBase<A, B>, B extends Property> extends IcsTimeZoneAwarePropertyBase<A, B> {

    protected IcsDateTimePropertyBase(String name, String value, ListF<? extends IcsParameter> parameters) {
        super(name, value, parameters);
    }

    protected IcsDateTimePropertyBase(String name, IcsDateTime time) {
        this(name, time.toPropertyValue(), time.toPropertyParameters());
    }

    public boolean isDate() {
        return getIcsDateTime().isDate();
    }

    public boolean isWithZone() {
        return getValue().endsWith("Z") || hasParameter(TzId.TZID);
    }

    public DateTime getDateTime(IcsVTimeZones timezones) {
        return getIcsDateTime().getDateTime(timezones);
    }

    public LocalDateTime getLocalDateTime() {
        return IcsDateTimeFormats.DATE_TIME_FORMATTER.parseDateTime(getValue()).toLocalDateTime();
    }

    public LocalDate getLocalDate() {
        return IcsDateTimeFormats.DATE_FORMATTER.parseDateTime(getValue()).toLocalDate();
    }

    public IcsDateTime getIcsDateTime() {
        return IcsDateTime.parse(getValue(), getTzId());
    }

    public static Function<IcsDateTimePropertyBase<?, ?>, Instant> getInstantF(IcsVTimeZones timezones) {
        return p -> p.getIcsDateTime().getInstant(timezones);
    }

    public Instant getInstant(IcsVTimeZones timezones) {
        return getInstantF(timezones).apply(this);
    }

    @Override
    public Property toPropertyForSerialization() {
        // workaround against net.fortuna.ical4j.model.property.DateProperty (it parses date and always prints date with time part)
        XProperty xProperty = new XProperty(getName(), getValue());
        for (IcsParameter parameter : getParameters()) {
            xProperty.getParameters().add(parameter.toParameter());
        }
        return xProperty;
    }

    public static Function1B<IcsDateTimePropertyBase> isDateF() {
        return new Function1B<IcsDateTimePropertyBase>() {
            public boolean apply(IcsDateTimePropertyBase p) {
                return p.isDate();
            }
        };
    }

} //~
