package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsVTimeZones;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;

/**
 * @author Stepan Koltsov
 */
public class IcsDateTimeUtcPropertyBase<A extends IcsDateTimeUtcPropertyBase<A, B>, B extends Property>
        extends IcsDateTimePropertyBase<A, B>
{

    protected IcsDateTimeUtcPropertyBase(String name, String value, ListF<? extends IcsParameter> parameters) {
        super(name, value, parameters);
    }

    public Instant getInstant() {
        return getIcsDateTime().getInstant(IcsVTimeZones.fallback(DateTimeZone.UTC));
    }

    public static Function<IcsDateTimeUtcPropertyBase<?, ?>, Instant> getInstantF() {
        return new Function<IcsDateTimeUtcPropertyBase<?, ?>, Instant>() {
            public Instant apply(IcsDateTimeUtcPropertyBase<?, ?> lastModified) {
                return lastModified.getInstant();
            }
        };
    }

} //~
