package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.DtEnd;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTime;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=Property.DTEND, theirClass=DtEnd.class)
public class IcsDtEnd extends IcsDateTimePropertyBase<IcsDtEnd, DtEnd> {

    public IcsDtEnd(String value, ListF<? extends IcsParameter> parameters) {
        super(Property.DTEND, value, parameters);
    }

    public IcsDtEnd(IcsDateTime end) {
        super(Property.DTEND, end);
    }

    public IcsDtEnd(String value) {
        this(value, Cf.<IcsParameter>list());
    }

    public IcsDtEnd(Instant end) {
        this(IcsDateTime.instant(end));
    }

} //~
