package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.DtStamp;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTimeFormats;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=Property.DTSTAMP, theirClass=DtStamp.class)
public class IcsDtStamp extends IcsDateTimeUtcPropertyBase<IcsDtStamp, DtStamp> {

    public IcsDtStamp(String value, ListF<? extends IcsParameter> parameters) {
        super(Property.DTSTAMP, value, parameters);
    }

    public IcsDtStamp(Instant dtStamp) {
        this(IcsDateTimeFormats.formatDateTime(dtStamp), Cf.<IcsParameter>list());
    }

    public static IcsDtStamp now() {
        return new IcsDtStamp(new Instant());
    }

} //~
