package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.DtStart;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTime;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=Property.DTSTART, theirClass=DtStart.class)
public class IcsDtStart extends IcsDateTimePropertyBase<IcsDtStart, DtStart> {

    public IcsDtStart(String value, ListF<? extends IcsParameter> parameters) {
        super(Property.DTSTART, value, parameters);
    }

    public IcsDtStart(IcsDateTime time) {
        super(Property.DTSTART, time);
    }

    public IcsDtStart(String value) {
        this(value, Cf.<IcsParameter>list());
    }

    public IcsDtStart(Instant start) {
        this(IcsDateTime.instant(start));
    }

} //~
