package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.Due;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTime;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=Property.DUE, theirClass=Due.class)
public class IcsDue extends IcsDateTimePropertyBase<IcsDue, Due> {

    public IcsDue(String value, ListF<? extends IcsParameter> parameters) {
        super(Property.DUE, value, parameters);
    }

    public IcsDue(IcsDateTime time) {
        super(Property.DUE, time);
    }

    public IcsDue(Instant instant) {
        this(IcsDateTime.instant(instant));
    }

} //~
