package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.Duration;
import org.joda.time.Period;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.IcsDurationValue;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=Property.DURATION, theirClass=Duration.class)
public class IcsDuration extends IcsPropertyBase<IcsDuration, Duration> {

    public IcsDuration(String value, ListF<IcsParameter> parameters) {
        super(Property.DURATION, value, parameters);
    }

    public IcsDurationValue getDurationValue() {
        return IcsDurationValue.parse(getValue());
    }

    public Period getPeriod() {
        return getDurationValue().getPeriod();
    }

} //~
