package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.parameter.Cn;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.bolts.function.Function2B;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.util.email.Emails;
import ru.yandex.misc.email.Email;

/**
 * @author Stepan Koltsov
 */
public abstract class IcsEmailPropertyBase<S extends IcsProperty, T extends Property> extends IcsPropertyBase<S, T> {

    protected IcsEmailPropertyBase(String name, String value, ListF<? extends IcsParameter> parameters) {
        super(name, value, parameters);
    }

    public Email getEmail() {
        return getEmailF().apply(this);
    }

    public String getUnicodedEmail() {
        return Emails.getUnicoded(getEmail());
    }

    public String getCn() {
        return getParameter(Cn.CN).map(IcsParameter.getValueF()).getOrElse("");
    }

    public boolean isEmail() {
        try {
            getEmail();
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    public boolean emailIs(Email email) {
        return isEmail() && getEmail().equalsIgnoreCase(email);
    }

    public static Function<IcsProperty, Email> getEmailF() {
        return valueF().andThen(Emails::punycodeMailto);
    }

    public static Function<IcsProperty, Option<Email>> getEmailSafeF() {
        return valueF().andThen(Emails::punycodeMailtoSafe);
    }

    public static Function2B<IcsAttendee, Email> emailIs() {
        return new Function2B<IcsAttendee, Email>() {
            public boolean apply(IcsAttendee a, Email e) {
                return a.emailIs(e);
            }
        };
    }

    public static Function1B<IcsAttendee> emailIsF(Email email) {
        return emailIs().bind2(email);
    }

    public static IcsEmailPropertyBase<?, ?> fromIcal4j(Property attendee) {
        return (IcsEmailPropertyBase<?, ?>) PropertiesMeta.M.fromIcal4j(attendee);
    }


} //~
