package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.ExDate;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsVTimeZones;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTime;

/**
 * @author Stepan Koltsov
 * @url http://tools.ietf.org/html/rfc5545#section-3.8.5.1
 */
@MappingToIcal4j(name=Property.EXDATE, theirClass=ExDate.class)
public class IcsExDate extends IcsDateTimeListPropertyBase<IcsExDate, ExDate> {

    public IcsExDate(String value, ListF<? extends IcsParameter> parameters) {
        super(Property.EXDATE, value, parameters);
    }

    public IcsExDate(IcsDateTime dateTime) {
        super(Property.EXDATE, dateTime);
    }

    public IcsExDate(Instant instant) {
        super(Property.EXDATE, instant);
    }

    public ListF<IcsDateTime> getIcsDateTimes() {
        return getValues().map(new Function<String, IcsDateTime>() {
            public IcsDateTime apply(String value) {
                return IcsDateTime.parse(value, getTzId());
            }
        });
    }

    public ListF<Instant> getInstants(IcsVTimeZones tzs) {
        return getIcsDateTimes().map(p -> p.getInstant(tzs));
    }

} //~
