package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.Method;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=Property.METHOD, theirClass=Method.class)
public class IcsMethod extends IcsPropertyBase<IcsMethod, Method> {

    public static final IcsMethod PUBLISH = new IcsMethod("PUBLISH");

    public static final IcsMethod REQUEST = new IcsMethod("REQUEST");

    public static final IcsMethod REPLY = new IcsMethod("REPLY");

    public static final IcsMethod ADD = new IcsMethod("ADD");

    public static final IcsMethod CANCEL = new IcsMethod("CANCEL");

    public static final IcsMethod REFRESH = new IcsMethod("REFRESH");

    public static final IcsMethod COUNTER = new IcsMethod("COUNTER");

    public static final IcsMethod DECLINE_COUNTER = new IcsMethod("DECLINE-COUNTER");


    public IcsMethod(String value, ListF<IcsParameter> parameters) {
        super(Property.METHOD, value, parameters);
    }

    public IcsMethod(String value) {
        this(value, Cf.<IcsParameter>list());
    }

    public boolean sameMethodAs(IcsMethod method) {
        return super.sameNameAndValue(method);
    }

    public boolean methodIs(String method) {
        // All names of ... , enumerated property values ... are case-insensitive
        // See http://tools.ietf.org/html/rfc2445#section-2
        return getValue().equalsIgnoreCase(method);
    }

    public boolean methodIs(IcsMethod method) {
        return methodIs(method.getValue());
    }

} //~
