package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.Organizer;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.util.email.Emails;
import ru.yandex.misc.email.Email;

@MappingToIcal4j(name=Property.ORGANIZER, theirClass=Organizer.class)
public class IcsOrganizer extends IcsEmailPropertyBase<IcsOrganizer, Organizer> {

    public IcsOrganizer(String value, ListF<IcsParameter> parameters) {
        super(Property.ORGANIZER, value, parameters);
    }

    public IcsOrganizer(Email email) {
        this(Emails.getUnicodedMailto(email), Cf.<IcsParameter>list());
    }

    @Override
    public Organizer toProperty() {
        return (Organizer) super.toProperty();
    }

    public static IcsOrganizer fromIcal4j(Organizer attendee) {
        return (IcsOrganizer) PropertiesMeta.M.fromIcal4j(attendee);
    }

} //~
