package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.IcsUtils;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.support.IvObject;
import ru.yandex.calendar.logic.ics.iv5j.vcard.property.VcfProperty;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Stepan Koltsov
 * @see VcfProperty
 */
public abstract class IcsProperty extends IvObject {

    private final String value;
    private final ListF<IcsParameter> parameters;

    protected IcsProperty(String name, String value, ListF<? extends IcsParameter> parameters) {
        super(name);
        this.value = value;
        this.parameters = parameters.uncheckedCast();
    }

    public String getValue() {
        return value;
    }

    public ListF<IcsParameter> getParameters() {
        return parameters;
    }

    // XXX: can we have multiple parameters?
    public <P extends IcsParameter> ListF<P> getParameters(String name) {
        return parameters.filter(IcsParameter.nameIsF(name)).uncheckedCast();
    }

    public <P extends IcsParameter> Option<P> getParameter(String name) {
        return this.<P>getParameters(name).singleO();
    }

    public boolean hasParameter(String name) {
        return getParameters(name).isNotEmpty();
    }

    public Property toProperty() {
        try {
            Property p = PropertiesMeta.M.newTheir(name);
            p.setValue(value);
            for (IcsParameter parameter : parameters) {
                p.getParameters().add(parameter.toParameter());
            }
            return p;
        } catch (Exception e) {
            throw IcsUtils.translate(e);
        }
    }

    public Property toPropertyForSerialization() {
        return toProperty();
    }

    public static Function<IcsProperty, String> valueF() {
        return IcsProperty::getValue;
    }

    public final boolean sameNameAndValue(IcsProperty property) {
        return
            this.name.equals(property.name) &&
            this.value.equals(property.value);
    }

    public final boolean sameAs(IcsProperty property) {
        return sameNameAndValue(property) &&
            this.parameters.equals(property.parameters);
    }

    public final boolean equals(Object that) {
        return that instanceof IcsProperty && sameAs((IcsProperty) that);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String serialize() {
        return toProperty().toString();
    }

    public String toString() {
        return StringUtils.lines(serialize()).mkString("");
    }

    public static Function<IcsProperty, String> serializeF() {
        return new Function<IcsProperty, String>() {
            public String apply(IcsProperty p) {
                return p.serialize();
            }
        };
    }
} //~
