package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.RDate;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.IcsPeriod;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.IcsRDateInterval;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTime;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=Property.RDATE, theirClass=RDate.class)
public class IcsRDate extends IcsDateTimeListPropertyBase<IcsRDate, RDate> {

    public IcsRDate(String value, ListF<? extends IcsParameter> parameters) {
        super(Property.RDATE, value, parameters);
    }

    public IcsRDate(Instant instant) {
        super(Property.RDATE, instant);
    }

    public IcsRDate(IcsDateTime dateTime) {
        super(Property.RDATE, dateTime);
    }

    public IcsRDate(IcsRDateInterval interval) {
        this(interval.toPropertyValue(), interval.toPropertyParameters());
    }

    public IcsRDate(IcsDateTime start, IcsDateTime end) {
        this(IcsRDateInterval.period(new IcsPeriod(start, end)));
    }

    public ListF<IcsRDateInterval> getIntervals() {
        return getValues().map(new Function<String, IcsRDateInterval>() {
            public IcsRDateInterval apply(String value) {
                return IcsRDateInterval.parse(value, getTzId());
            }
        });
    }

} //~
