package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.RRule;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.IcsRecur;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.IcsRecurParser;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=Property.RRULE, theirClass=RRule.class)
public class IcsRRule extends IcsPropertyBase<IcsRRule, RRule> {

    private final IcsRecur recur;

    public IcsRRule(String value, ListF<IcsParameter> parameters) {
        super(Property.RRULE, value, parameters);
        this.recur = IcsRecurParser.P.parseRecur(value);
    }

    public IcsRRule(String value) {
        this(value, Cf.<IcsParameter>list());
    }

    public IcsRRule(IcsRecur recur) {
        super(Property.RRULE, recur.getValue(), Cf.<IcsParameter>list());
        this.recur = recur;
    }

    public IcsRecur getRecur() {
        return recur;
    }

    @Override
    public Property toPropertyForSerialization() {
        // do not want to parse recur again with ical4j that does not serialize until date properly
        return new XPropertyNotEscapable(getName(), new ParameterList(), getValue());
    }
} //~
