package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.RecurrenceId;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTime;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTimeFormats;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=Property.RECURRENCE_ID, theirClass=RecurrenceId.class)
public class IcsRecurrenceId extends IcsDateTimePropertyBase<IcsRecurrenceId, RecurrenceId> {

    public IcsRecurrenceId(String value, ListF<? extends IcsParameter> parameters) {
        super(Property.RECURRENCE_ID, value, parameters);
    }

    public IcsRecurrenceId(Instant recurranceId) {
        this(IcsDateTimeFormats.formatDateTime(recurranceId), Cf.<IcsParameter>list());
    }

    public IcsRecurrenceId(DateTime recurrenceId) {
        super(Property.RECURRENCE_ID, IcsDateTime.dateTime(recurrenceId));
    }

    public IcsRecurrenceId(LocalDate recurrenceId) {
        super(Property.RECURRENCE_ID, IcsDateTime.localDate(recurrenceId));
    }

} //~
