package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.Sequence;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=Property.SEQUENCE, theirClass=Sequence.class)
public class IcsSequence extends IcsPropertyBase<IcsSequence, Sequence> {

    public IcsSequence(String value, ListF<IcsParameter> parameters) {
        super(Property.SEQUENCE, value, parameters);
    }

    public IcsSequence(int sequence) {
        this(Integer.toString(sequence), Cf.<IcsParameter>list());
    }
} //~
