package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.parameter.TzId;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsTzId;

/**
 * @author Stepan Koltsov
 */
public class IcsTimeZoneAwarePropertyBase<A extends IcsProperty, B extends Property> extends IcsPropertyBase<A, B> {

    protected IcsTimeZoneAwarePropertyBase(String name, String value, ListF<? extends IcsParameter> parameters) {
        super(name, value, parameters);
    }

    public Option<IcsTzId> getIcsTzId() {
        return getParameter(TzId.TZID);
    }

    public Option<String> getTzId() {
        return getIcsTzId().map(IcsParameter::getValue);
    }
} //~
