package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.Trigger;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsRelated;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsValue;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTime;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=Property.TRIGGER, theirClass=Trigger.class)
public class IcsTrigger extends IcsPropertyBase<IcsTrigger, Trigger> {

    public IcsTrigger(String value, ListF<? extends IcsParameter> parameters) {
        super(Property.TRIGGER, value, parameters);
    }

    public static IcsTrigger createDateTime(Instant instant) {
        return new IcsTrigger(IcsDateTime.instant(instant).toPropertyValue(), Cf.list(IcsValue.DATE_TIME));
    }

    public static IcsTrigger createDuration(String durationValue, boolean withValueParameter, Option<IcsRelated> relatedO) {
        ListF<IcsParameter> parameters = Cf.arrayList();
        if (withValueParameter) {
            parameters.add(IcsValue.DURATION); // optional: this is the default
        }
        if (relatedO.isPresent()) {
            parameters.add(relatedO.get()); // optional: default value is START
        }
        return new IcsTrigger(durationValue, parameters);
    }

    public IcsRelated getRelationOrGetDefault() {
        return (IcsRelated) getParameter(Parameter.RELATED).getOrElse(IcsRelated.START);
    }

    public IcsValue getValueTypeOrGetDefault() {
        return (IcsValue) getParameter(Parameter.VALUE).getOrElse(IcsValue.DURATION);
    }
} //~
