package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.property.XProperty;
import org.joda.time.DateTimeZone;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.MappingToIcal4j;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;

/**
 * @author Stepan Koltsov
 */
@MappingToIcal4j(name=IcsXWrTimezone.X_WR_TIMEZONE, theirClass=XProperty.class)
public class IcsXWrTimezone extends IcsPropertyBase<IcsXWrTimezone, XProperty> {

    public static final String X_WR_TIMEZONE = "X-WR-TIMEZONE";

    public IcsXWrTimezone(String value, ListF<? extends IcsParameter> parameters) {
        super("X-WR-TIMEZONE", value, parameters);
    }

    public IcsXWrTimezone(String value) {
        this(value, Cf.<IcsParameter>list());
    }

    public IcsXWrTimezone(DateTimeZone tz) {
        this(tz.getID());
    }

} //~
