package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.XProperty;
import net.fortuna.ical4j.util.Strings;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.IcssMeta;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.ParametersMeta;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Stepan Koltsov
 */
public class PropertiesMeta extends IcssMeta<IcsProperty, IcsXProperty, Property, XProperty, PropertyMeta> {

    public static final PropertiesMeta M = new PropertiesMeta();

    private PropertiesMeta() {
        super(new Class[] {
                IcsAction.class,
                IcsAttach.class,
                IcsAttendee.class,
                IcsBusyType.class,
                IcsCalScale.class,
                IcsCategories.class,
                IcsClass.class,
                IcsComment.class,
                IcsCompleted.class,
                IcsContact.class,
                IcsCountry.class,
                IcsCreated.class,
                IcsDescription.class,
                IcsDtEnd.class,
                IcsDtStamp.class,
                IcsDtStart.class,
                IcsDuration.class,
                IcsDue.class,
                IcsExDate.class,
                IcsExRule.class,
                IcsExtendedAddress.class,
                IcsFreeBusy.class,
                IcsGeo.class,
                IcsLastModified.class,
                IcsLocality.class,
                IcsLocation.class,
                IcsLocationType.class,
                IcsMethod.class,
                IcsName.class,
                IcsOrganizer.class,
                IcsPercentComplete.class,
                IcsPostalcode.class,
                IcsPriority.class,
                IcsProdId.class,
                IcsRRule.class,
                IcsRDate.class,
                IcsRecurrenceId.class,
                IcsRegion.class,
                IcsRelatedTo.class,
                IcsRepeat.class,
                IcsRequestStatus.class,
                IcsResources.class,
                IcsSequence.class,
                IcsStatus.class,
                IcsStreetAddress.class,
                IcsSummary.class,
                IcsTel.class,
                IcsTransp.class,
                IcsTrigger.class,
                IcsTzId.class,
                IcsTzName.class,
                IcsTzOffsetFrom.class,
                IcsTzOffsetTo.class,
                IcsTzUrl.class,
                IcsUid.class,
                IcsUrl.class,
                IcsVersion.class,
                IcsXWrCalname.class,
                IcsXWrTimezone.class,
                IcsConference.class,
                IcsAcknowledged.class,
                IcsColor.class,
                IcsImage.class,
                IcsRefreshInterval.class,
                IcsSource.class,
        });
    }

    @Override
    protected PropertyMeta newMeta(String name, ClassX<IcsProperty> ourClass, ClassX<Property> theirClass) {
        return new PropertyMeta(name, ourClass, theirClass);
    }

    public Property newTheir(String name) {
        Option<PropertyMeta> meta = metaByName(name);
        if (meta.isPresent()) {
            return meta.get().newProperty();
        } else if (IcsXPropertyNotEscapable.names.containsTs(name)) {
            return new XPropertyNotEscapable(name);
        } else {
            return new XProperty(name);
        }
    }

    public IcsProperty newOur(String name, String value, ListF<IcsParameter> parameters) {
        Option<PropertyMeta> meta = metaByName(name);
        if (meta.isPresent()) {
            return meta.get().newOur(value, parameters);
        } else if (IcsXPropertyNotEscapable.names.containsTs(name)) {
            return new IcsXPropertyNotEscapable(name, value, parameters);
        } else {
            return new IcsXProperty(name, value, parameters);
        }
    }

    public IcsProperty newOur(String name, String value) {
        return newOur(name, value, Cf.<IcsParameter>list());
    }

    @SuppressWarnings("unchecked")
    public IcsProperty fromIcal4j(Property p) {
        String name = p.getName();
        String value;

        // http://sourceforge.net/tracker/?func=detail&aid=3411959&group_id=107024&atid=646395
        if (p instanceof RDate) {
            RDate rdate = (RDate) p;
            DateList dates = rdate.getDates();
            if (dates != null && !dates.isEmpty()) {
                value = Strings.valueOf(rdate.getDates());
            } else {
                value = p.getValue();
            }
        } else {
            value = p.getValue();
        }

        ListF<IcsParameter> parameters =
            Cf.<Parameter>x(p.getParameters().iterator()).toList().map(ParametersMeta.M.fromIcal4jF());
        return newOur(name, value, parameters);
    }

    public Function<Property, IcsProperty> fromIcal4jF() {
        return new Function<Property, IcsProperty>() {
            public IcsProperty apply(Property p) {
                return fromIcal4j(p);
            }
        };
    }



} //~
