package ru.yandex.calendar.logic.ics.iv5j.ical.property;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.XProperty;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function0;
import ru.yandex.bolts.function.Function2;
import ru.yandex.calendar.logic.ics.iv5j.ical.meta.IcsMeta;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.util.base.Cf2;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Stepan Koltsov
 */
public class PropertyMeta extends IcsMeta<IcsProperty, Property, PropertyMeta> {

    private final Function0<Property> theirConstructor;
    private final Function2<String, ListF<IcsParameter>, IcsProperty> ourConstructor;

    public PropertyMeta(String name, ClassX<IcsProperty> ourComponent, ClassX<Property> theirComponent) {
        super(name, ourComponent, theirComponent);

        if (theirComponent.sameAs(XProperty.class)) {
            this.theirConstructor = Cf2.consF(theirComponent, String.class).bind(name);
        } else {
            this.theirConstructor = Cf2.consF(theirComponent);
        }
        this.ourConstructor = Cf2.consF(ourComponent, String.class, Cf2.listClass());
    }

    public Property newProperty() {
        return theirConstructor.apply();
    }

    public IcsProperty newOur(String value, ListF<IcsParameter> parameters) {
        return ourConstructor.apply(value, parameters);
    }

} //~
