package ru.yandex.calendar.logic.ics.iv5j.ical.type;

import org.joda.time.Period;

import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Stepan Koltsov
 */
public class IcsDurationValue {
    private static final Logger logger = LoggerFactory.getLogger(IcsDurationValue.class);

    private final Period period;

    public IcsDurationValue(Period period) {
        this.period = period;
    }

    public Period getPeriod() {
        return period;
    }

    public static IcsDurationValue parse(String string) {
        return new IcsDurationValue(IcsDurationValueParser.parser().parse(string));
    }

    public String toPropertyValue() {
        logger.error("Duration serialization is not implemented");
        return "PT1H";
    }
} //~
