package ru.yandex.calendar.logic.ics.iv5j.ical.type;

import org.joda.time.Period;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function2;
import ru.yandex.commune.util.jparsec.CommonParsers;
import ru.yandex.commune.util.jparsec.Parser2;

/**
 * @author Stepan Koltsov
 */
public class IcsDurationValueParser {

    @SuppressWarnings("unchecked")
    static Parser2<Period> parser() {
        Parser2<Integer> sign = CommonParsers.string("+").retn(1).or(CommonParsers.string("-").retn(-1)).optional(1);
        return sign.followedBy(CommonParsers.string("P")).andThen(Parser2.or(durDate(), durTime(), durWeek())).map(new Function2<Integer, Period, Period>() {
            public Period apply(Integer sign, Period p) {
                if (sign > 0) {
                    return p;
                } else {
                    return new Period(-p.toStandardDuration().getMillis());
                }
            }
        });

    }

    private static Parser2<Period> durDate() {
        return durDay().andThen(durTime().optional()).map(foldPeriodF()).atomic();
    }

    @SuppressWarnings("unchecked")
    private static Parser2<Period> durTime() {
        return CommonParsers.string("T").next(Parser2.or(durHour(), durMinute(), durSecond())).atomic();
    }

    private static Parser2<Period> durWeek() {
        return CommonParsers.intP().followedBy(CommonParsers.string("W")).map(new Function<Integer, Period>() {
            public Period apply(Integer weeks) {
                return Period.weeks(weeks);
            }
        }).atomic();
    }

    private static Parser2<Period> durHour() {
        return CommonParsers.intP().followedBy(CommonParsers.string("H")).map(new Function<Integer, Period>() {
            public Period apply(Integer hours) {
                return Period.hours(hours);
            }
        }).andThen(durMinute().optional()).map(foldPeriodF()).atomic();
    }

    private static Parser2<Period> durMinute() {
        return CommonParsers.intP().followedBy(CommonParsers.string("M")).map(new Function<Integer, Period>() {
            public Period apply(Integer minutes) {
                return Period.minutes(minutes);
            }
        }).andThen(durSecond().optional()).map(foldPeriodF()).atomic();
    }

    private static Parser2<Period> durSecond() {
        return CommonParsers.intP().followedBy(CommonParsers.string("S")).map(new Function<Integer, Period>() {
            public Period apply(Integer seconds) {
                return Period.seconds(seconds);
            }
        }).atomic();
    }

    private static Parser2<Period> durDay() {
        return CommonParsers.intP().followedBy(CommonParsers.string("D")).map(new Function<Integer, Period>() {
            public Period apply(Integer days) {
                return Period.days(days);
            }
        }).atomic();
    }

    private static Function2<Period, Option<Period>, Period> foldPeriodF() {
        return new Function2<Period, Option<Period>, Period>() {
            public Period apply(Period a, Option<Period> b) {
                if (b.isPresent()) {
                    return a.plus(b.get());
                } else {
                    return a;
                }
            }
        };
    }


} //~
