package ru.yandex.calendar.logic.ics.iv5j.ical.type;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsVTimeZones;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTime;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author Stepan Koltsov
 */
public class IcsPeriod {
    private final IcsDateTime start;
    private final Either<IcsDateTime, IcsDurationValue> end;

    public IcsPeriod(IcsDateTime start, Either<IcsDateTime, IcsDurationValue> end) {
        this.start = start;
        this.end = end;
    }

    public IcsPeriod(IcsDateTime start, IcsDateTime end) {
        this(start, Either.<IcsDateTime, IcsDurationValue>left(end));
    }

    public IcsDateTime getStart() {
        return start;
    }

    public Either<IcsDateTime, IcsDurationValue> getEnd() {
        return end;
    }

    public Instant getEnd(IcsVTimeZones tz) {
        if (end.isLeft()) {
            return end.getLeft().getInstant(tz);
        } else {
            return getStart().getDateTime(tz).plus(end.getRight().getPeriod()).toInstant();
        }
    }

    public static IcsPeriod parse(String string, Option<String> tz) {
        Tuple2<String, String> p = Pattern2.compile("/").split2(string);

        IcsDateTime start = IcsDateTime.parse(p._1, tz);

        Either<IcsDateTime, IcsDurationValue> end;
        if (p._2.matches("^[P+-].*")) {
            end = Either.right(IcsDurationValue.parse(p._2));
        } else {
            end = Either.left(IcsDateTime.parse(p._2, tz));
        }

        return new IcsPeriod(start, end);
    }

    public String toPropertyValue() {
        if (end.isLeft()) {
            return start.toPropertyValue() + "/" + end.getLeft().toPropertyValue();
        } else {
            return start.toPropertyValue() + "/" + end.getRight().toPropertyValue();
        }
    }

    public ListF<IcsParameter> toPropertyParameters() {
        return start.toPropertyParameters();
    }

} //~
