package ru.yandex.calendar.logic.ics.iv5j.ical.type;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsVTimeZones;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTime;

/**
 * @author Stepan Koltsov
 */
public class IcsRDateInterval {
    private final Either<IcsDateTime, IcsPeriod> interval;

    public IcsRDateInterval(Either<IcsDateTime, IcsPeriod> interval) {
        this.interval = interval;
    }

    public Either<IcsDateTime, IcsPeriod> getInterval() {
        return interval;
    }

    public IcsDateTime getStartIcsDateTime() {
        if (interval.isLeft()) {
            return interval.getLeft();
        } else {
            return interval.getRight().getStart();
        }
    }

    public Instant getStart(IcsVTimeZones tz) {
        return getStartIcsDateTime().getInstant(tz);
    }

    public Option<Instant> getEnd(IcsVTimeZones tz) {
        if (interval.isLeft()) {
            return Option.empty();
        } else {
            return Option.of(interval.getRight().getEnd(tz));
        }
    }

    public static IcsRDateInterval time(IcsDateTime time) {
        return new IcsRDateInterval(Either.<IcsDateTime, IcsPeriod>left(time));
    }

    public static IcsRDateInterval period(IcsPeriod period) {
        return new IcsRDateInterval(Either.<IcsDateTime, IcsPeriod>right(period));
    }

    public static IcsRDateInterval parse(String string, Option<String> tz) {
        if (string.contains("/")) {
            return period(IcsPeriod.parse(string, tz));
        } else {
            return time(IcsDateTime.parse(string, tz));
        }
    }

    public String toPropertyValue() {
        if (interval.isLeft()) {
            return interval.getLeft().toPropertyValue();
        } else {
            return interval.getRight().toPropertyValue();
        }
    }

    public ListF<IcsParameter> toPropertyParameters() {
        if (interval.isLeft()) {
            return interval.getLeft().toPropertyParameters();
        } else {
            return interval.getRight().toPropertyParameters();
        }
    }

} //~
