package ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime;

import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import ru.yandex.bolts.function.Function;

/**
 * @author Stepan Koltsov
 */
public class IcsDateTimeFormats {

    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern("YYYYMMdd").withZone(DateTimeZone.UTC);
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern("YYYYMMdd'T'HHmmss").withZone(DateTimeZone.UTC);
    public static final DateTimeFormatter dateTimeZPattern = DateTimeFormat.forPattern("yyyyMMdd'T'HHmmss'Z'").withZone(DateTimeZone.UTC);

    public static String formatDateTime(Instant instant) {
        return IcsDateTimeFormats.dateTimeZPattern.print(instant);
    }

    public static Instant parseDateTime(String dateTime) {
        return IcsDateTimeFormats.dateTimeZPattern.parseDateTime(dateTime).toInstant();
    }

    public static Function<String, Instant> parseDateTimeF() {
        return new Function<String, Instant>() {
            public Instant apply(String s) {
                return parseDateTime(s);
            }
        };
    }

    public static LocalDate parseDate(String date) {
        return DATE_FORMATTER.parseLocalDate(date);
    }

    public static String formatDate(LocalDate localDate) {
        return DATE_FORMATTER.print(localDate);
    }

} //~
