package ru.yandex.calendar.logic.ics.iv5j.ical.type.recur;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author Stepan Koltsov
 */
public class IcsRecurParser {

    public static final IcsRecurParser P = new IcsRecurParser();

    public IcsRecur parseRecur(String value) {
        return new IcsRecur(Cf.list(value.split(";")).map(parsePartF()));
    }

    public IcsRecurRulePart parsePart(String value) {
        Tuple2<String, String> nameValue = Pattern2.compile("=").split2(value);
        return IcsRecurRuleParts.P.newPart(nameValue._1, nameValue._2);
    }

    public Function<String, IcsRecurRulePart> parsePartF() {
        return this::parsePart;
    }
} //~
