package ru.yandex.calendar.logic.ics.iv5j.ical.type.recur;

import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.iv5j.support.IvObject;


/**
 * @author Stepan Koltsov
 */
public abstract class IcsRecurRulePart extends IvObject {

    private final String value;

    protected IcsRecurRulePart(String name, String value) {
        super(name);
        this.value = value;
    }

    @Override
    public String toString() {
        return name + "=" + value;
    }

    public String getValue() {
        return value;
    }

    public static Function<IcsRecurRulePart, String> getValueF() {
        return new Function<IcsRecurRulePart, String>() {
            public String apply(IcsRecurRulePart icsRecurRulePart) {
                return icsRecurRulePart.getValue();
            }
        };
    }

} //~
